using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Printing;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmIssueBloodComponents
	/// </summary>
	public class FrmIssueBloodComponents : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		// All business rules are defined in this PatientUnitIssue class except for 
		// BR_73.07 which is implemented in the spGetOrderedUnitsForPatient stored procedure.

		#region userDefinedVariables

		/// <summary>
		/// Issue that holds all information pertaining to unit issue
		/// </summary>
		BOL.PatientUnitIssue _pUI;
		/// <summary>
		/// Is form loading
		/// </summary>
		bool _loading;

		// for UnitID/ ProductCode
		private Regex _isbtUnitID;
		private Regex _isbtProductCode;
		private Regex _codabarUnitID;
		private Regex _codabarProductCode;

		private BOL.BloodUnit _scannedBloodUnit;


		#endregion


		#region systemDefinedVariables

        private System.Windows.Forms.GroupBox grpIssueDetails;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.Label lblIssueDate;
		private System.Windows.Forms.Label lblTransporter;
		private System.Windows.Forms.Label lblLocationName;
		private System.Windows.Forms.TextBox txtIssueDate;
		private System.Windows.Forms.TextBox txtTransporter;
		private System.Windows.Forms.TextBox txtLocationName;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnIssueUnits;
		private System.Windows.Forms.Button btnCancelUnits;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox grpSelectedUnit;
		private gov.va.med.vbecs.GUI.controls.BloodUnitDetailsTab bloodUnitDetailsTab1;
		private gov.va.med.vbecs.GUI.controls.BloodUnitLabel bloodBagLabel1;
		private System.Windows.Forms.TabControl tabUnits;
		private System.Windows.Forms.TabPage pageIssueUnits;
		private System.Windows.Forms.ListView lvIssueUnits;
		private System.Windows.Forms.TabPage pageEmergencyIssueUnits;
		private System.Windows.Forms.ListView lvEmergencyIssueUnits;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader10;
		private System.Windows.Forms.ColumnHeader columnHeader11;
		private System.Windows.Forms.ColumnHeader columnHeader12;
		private System.Windows.Forms.ColumnHeader columnHeader13;
		private System.Windows.Forms.ColumnHeader columnHeader14;
		private System.Windows.Forms.ContextMenu mnuInspection;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.ImageList imageList1;
		private System.Windows.Forms.CheckBox cbUnsatisfactory;
		private System.ComponentModel.IContainer components = null;
		private System.Windows.Forms.GroupBox grpSelect;
		private System.Windows.Forms.Button btnClear;
		private System.Windows.Forms.PictureBox pictureBox2;
		private System.Windows.Forms.PictureBox pictureBox4;
		private System.Windows.Forms.Label lblUnitID;
		private System.Windows.Forms.Label lblProduct;
		private System.Windows.Forms.PrintDialog printDialog1;
		private static Common.WorkloadProcessID _workloadProcessId = Common.WorkloadProcessID.IssueUnit;

		/// <summary>
		/// txtProductID
		/// </summary>
		public gov.va.med.vbecs.GUI.controls.ProductCodeTextbox txtProductID;
        private controls.PatientDisplayPanel patientDisplayPanel1;

		/// <summary>
		/// txtUnitID
		/// </summary>
		public gov.va.med.vbecs.GUI.controls.UnitIDTextbox txtUnitID;

		#endregion

		
		#region constructors

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="pUI"></param>
		public FrmIssueBloodComponents(BOL.PatientUnitIssue pUI)
		{
			this.LockController.LockFunction = Common.LockFunctions.UC073IssueBloodComponents;

			_loading = true;
	
			_pUI = pUI;

			// This call is required by the Windows Form Designer.
			InitializeComponent();
			SetComponentProperties();

			_pUI.Valid += new System.EventHandler(CheckValid);
			_pUI.Invalid += new System.EventHandler(CheckValid);

			_pUI.SetInitialBrokenRules(this.Name);

			_codabarProductCode = Common.RegularExpressions.CodabarProductCode();
			_codabarUnitID = Common.RegularExpressions.PooledCodabarEyeReadableUnitId();
			_isbtProductCode = Common.RegularExpressions.ISBT128ProductCode();
			_isbtUnitID = Common.RegularExpressions.ISBT128UnitID();

			if ((pUI.EmergencyUnits.Count>0) && (pUI.Units.Count==0))
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC073.FrmIssueBloodComponents_ER());
			}
			else
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC073.FrmIssueBloodComponents());
			}

			_loading = false;
		}

		#endregion


		#region methods

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmIssueBloodComponents));
            this.btnIssueUnits = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnCancelUnits = new System.Windows.Forms.Button();
            this.grpIssueDetails = new System.Windows.Forms.GroupBox();
            this.txtLocationName = new System.Windows.Forms.TextBox();
            this.txtTransporter = new System.Windows.Forms.TextBox();
            this.txtIssueDate = new System.Windows.Forms.TextBox();
            this.lblLocationName = new System.Windows.Forms.Label();
            this.lblIssueDate = new System.Windows.Forms.Label();
            this.lblTransporter = new System.Windows.Forms.Label();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.grpSelectedUnit = new System.Windows.Forms.GroupBox();
            this.cbUnsatisfactory = new System.Windows.Forms.CheckBox();
            this.bloodUnitDetailsTab1 = new gov.va.med.vbecs.GUI.controls.BloodUnitDetailsTab();
            this.bloodBagLabel1 = new gov.va.med.vbecs.GUI.controls.BloodUnitLabel(this.components);
            this.tabUnits = new System.Windows.Forms.TabControl();
            this.pageIssueUnits = new System.Windows.Forms.TabPage();
            this.lvIssueUnits = new System.Windows.Forms.ListView();
            this.columnHeader1 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader2 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader3 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader4 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader5 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.mnuInspection = new System.Windows.Forms.ContextMenu();
            this.menuItem1 = new System.Windows.Forms.MenuItem();
            this.menuItem2 = new System.Windows.Forms.MenuItem();
            this.imageList1 = new System.Windows.Forms.ImageList(this.components);
            this.pageEmergencyIssueUnits = new System.Windows.Forms.TabPage();
            this.lvEmergencyIssueUnits = new System.Windows.Forms.ListView();
            this.columnHeader10 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader11 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader12 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader13 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader14 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.grpSelect = new System.Windows.Forms.GroupBox();
            this.btnClear = new System.Windows.Forms.Button();
            this.txtProductID = new gov.va.med.vbecs.GUI.controls.ProductCodeTextbox(this.components);
            this.txtUnitID = new gov.va.med.vbecs.GUI.controls.UnitIDTextbox(this.components);
            this.pictureBox2 = new System.Windows.Forms.PictureBox();
            this.pictureBox4 = new System.Windows.Forms.PictureBox();
            this.lblUnitID = new System.Windows.Forms.Label();
            this.lblProduct = new System.Windows.Forms.Label();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            this.patientDisplayPanel1 = new gov.va.med.vbecs.GUI.controls.PatientDisplayPanel();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpIssueDetails.SuspendLayout();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.grpSelectedUnit.SuspendLayout();
            this.tabUnits.SuspendLayout();
            this.pageIssueUnits.SuspendLayout();
            this.pageEmergencyIssueUnits.SuspendLayout();
            this.grpSelect.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox4)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(762, 30);
            this.vbecsLogo1.TabIndex = 7;
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 549);
            this.lblRequiredField.TabIndex = 9;
            // 
            // btnIssueUnits
            // 
            this.btnIssueUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnIssueUnits.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnIssueUnits.Image = ((System.Drawing.Image)(resources.GetObject("btnIssueUnits.Image")));
            this.btnIssueUnits.Location = new System.Drawing.Point(606, 528);
            this.btnIssueUnits.Name = "btnIssueUnits";
            this.btnIssueUnits.Size = new System.Drawing.Size(75, 23);
            this.btnIssueUnits.TabIndex = 7;
            this.btnIssueUnits.Click += new System.EventHandler(this.btnIssueUnits_Click);
            // 
            // btnCancelUnits
            // 
            this.btnCancelUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancelUnits.CausesValidation = false;
            this.btnCancelUnits.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancelUnits.Location = new System.Drawing.Point(686, 528);
            this.btnCancelUnits.Name = "btnCancelUnits";
            this.btnCancelUnits.Size = new System.Drawing.Size(75, 23);
            this.btnCancelUnits.TabIndex = 8;
            this.btnCancelUnits.Text = "&Cancel";
            this.btnCancelUnits.Click += new System.EventHandler(this.btnCancelUnits_Click);
            // 
            // grpIssueDetails
            // 
            this.grpIssueDetails.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpIssueDetails.Controls.Add(this.txtLocationName);
            this.grpIssueDetails.Controls.Add(this.txtTransporter);
            this.grpIssueDetails.Controls.Add(this.txtIssueDate);
            this.grpIssueDetails.Controls.Add(this.lblLocationName);
            this.grpIssueDetails.Controls.Add(this.lblIssueDate);
            this.grpIssueDetails.Controls.Add(this.lblTransporter);
            this.grpIssueDetails.Location = new System.Drawing.Point(48, 68);
            this.grpIssueDetails.Name = "grpIssueDetails";
            this.grpIssueDetails.Size = new System.Drawing.Size(712, 40);
            this.grpIssueDetails.TabIndex = 1;
            this.grpIssueDetails.TabStop = false;
            // 
            // txtLocationName
            // 
            this.txtLocationName.AccessibleDescription = "location name";
            this.txtLocationName.AccessibleName = "location name";
            this.txtLocationName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtLocationName.Location = new System.Drawing.Point(504, 12);
            this.txtLocationName.Name = "txtLocationName";
            this.txtLocationName.ReadOnly = true;
            this.txtLocationName.Size = new System.Drawing.Size(200, 20);
            this.txtLocationName.TabIndex = 5;
            // 
            // txtTransporter
            // 
            this.txtTransporter.AccessibleDescription = "transporter";
            this.txtTransporter.AccessibleName = "transporter";
            this.txtTransporter.Location = new System.Drawing.Point(282, 12);
            this.txtTransporter.Name = "txtTransporter";
            this.txtTransporter.ReadOnly = true;
            this.txtTransporter.Size = new System.Drawing.Size(132, 20);
            this.txtTransporter.TabIndex = 3;
            // 
            // txtIssueDate
            // 
            this.txtIssueDate.AccessibleDescription = "issue date";
            this.txtIssueDate.AccessibleName = "issue date";
            this.txtIssueDate.Location = new System.Drawing.Point(64, 12);
            this.txtIssueDate.Name = "txtIssueDate";
            this.txtIssueDate.ReadOnly = true;
            this.txtIssueDate.Size = new System.Drawing.Size(136, 20);
            this.txtIssueDate.TabIndex = 1;
            // 
            // lblLocationName
            // 
            this.lblLocationName.Location = new System.Drawing.Point(428, 12);
            this.lblLocationName.Name = "lblLocationName";
            this.lblLocationName.Size = new System.Drawing.Size(80, 20);
            this.lblLocationName.TabIndex = 4;
            this.lblLocationName.Text = "Location Name";
            this.lblLocationName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblIssueDate
            // 
            this.lblIssueDate.Location = new System.Drawing.Point(8, 12);
            this.lblIssueDate.Name = "lblIssueDate";
            this.lblIssueDate.Size = new System.Drawing.Size(64, 20);
            this.lblIssueDate.TabIndex = 0;
            this.lblIssueDate.Text = "Issue Date";
            this.lblIssueDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblTransporter
            // 
            this.lblTransporter.Location = new System.Drawing.Point(220, 12);
            this.lblTransporter.Name = "lblTransporter";
            this.lblTransporter.Size = new System.Drawing.Size(64, 20);
            this.lblTransporter.TabIndex = 2;
            this.lblTransporter.Text = "Transporter";
            this.lblTransporter.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 68);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(40, 457);
            this.grpImage.TabIndex = 8;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(6, 10);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(28, 28);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
            this.pictureBox1.TabIndex = 0;
            this.pictureBox1.TabStop = false;
            // 
            // grpSelectedUnit
            // 
            this.grpSelectedUnit.AccessibleDescription = "selected unit";
            this.grpSelectedUnit.AccessibleName = "selected unit";
            this.grpSelectedUnit.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.grpSelectedUnit.Controls.Add(this.cbUnsatisfactory);
            this.grpSelectedUnit.Controls.Add(this.bloodUnitDetailsTab1);
            this.grpSelectedUnit.Controls.Add(this.bloodBagLabel1);
            this.grpSelectedUnit.Location = new System.Drawing.Point(478, 108);
            this.grpSelectedUnit.Name = "grpSelectedUnit";
            this.grpSelectedUnit.Size = new System.Drawing.Size(282, 414);
            this.grpSelectedUnit.TabIndex = 4;
            this.grpSelectedUnit.TabStop = false;
            this.grpSelectedUnit.Text = "Selected Unit";
            // 
            // cbUnsatisfactory
            // 
            this.cbUnsatisfactory.AccessibleDescription = "unsatisfactory for issue";
            this.cbUnsatisfactory.AccessibleName = "unsatisfactory for issue";
            this.cbUnsatisfactory.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cbUnsatisfactory.Enabled = false;
            this.cbUnsatisfactory.Location = new System.Drawing.Point(8, 390);
            this.cbUnsatisfactory.Name = "cbUnsatisfactory";
            this.cbUnsatisfactory.Size = new System.Drawing.Size(258, 20);
            this.cbUnsatisfactory.TabIndex = 6;
            this.cbUnsatisfactory.Text = "&Unsatisfactory for Issue?";
            this.cbUnsatisfactory.CheckedChanged += new System.EventHandler(this.cbUnsatisfactory_CheckedChanged);
            // 
            // bloodUnitDetailsTab1
            // 
            this.bloodUnitDetailsTab1.AccessibleDescription = "Blood Unit Details";
            this.bloodUnitDetailsTab1.AccessibleName = "Blood Unit Details";
            this.bloodUnitDetailsTab1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.bloodUnitDetailsTab1.BloodUnit = null;
            this.bloodUnitDetailsTab1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.bloodUnitDetailsTab1.Location = new System.Drawing.Point(8, 224);
            this.bloodUnitDetailsTab1.Name = "bloodUnitDetailsTab1";
            this.bloodUnitDetailsTab1.Size = new System.Drawing.Size(266, 166);
            this.bloodUnitDetailsTab1.TabIndex = 5;
            // 
            // bloodBagLabel1
            // 
            this.bloodBagLabel1.BackColor = System.Drawing.Color.WhiteSmoke;
            this.bloodBagLabel1.BloodUnit = null;
            this.bloodBagLabel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.bloodBagLabel1.Location = new System.Drawing.Point(8, 16);
            this.bloodBagLabel1.Name = "bloodBagLabel1";
            this.bloodBagLabel1.Size = new System.Drawing.Size(257, 204);
            this.bloodBagLabel1.TabIndex = 0;
            this.bloodBagLabel1.TabStop = false;
            // 
            // tabUnits
            // 
            this.tabUnits.AccessibleDescription = "units";
            this.tabUnits.AccessibleName = "units";
            this.tabUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.tabUnits.Controls.Add(this.pageIssueUnits);
            this.tabUnits.Controls.Add(this.pageEmergencyIssueUnits);
            this.tabUnits.Location = new System.Drawing.Point(48, 184);
            this.tabUnits.Name = "tabUnits";
            this.tabUnits.SelectedIndex = 0;
            this.tabUnits.Size = new System.Drawing.Size(426, 341);
            this.tabUnits.TabIndex = 3;
            this.tabUnits.SelectedIndexChanged += new System.EventHandler(this.tabUnits_SelectedIndexChanged);
            // 
            // pageIssueUnits
            // 
            this.pageIssueUnits.Controls.Add(this.lvIssueUnits);
            this.pageIssueUnits.Location = new System.Drawing.Point(4, 23);
            this.pageIssueUnits.Name = "pageIssueUnits";
            this.pageIssueUnits.Size = new System.Drawing.Size(418, 314);
            this.pageIssueUnits.TabIndex = 0;
            this.pageIssueUnits.Text = "Assigned Units";
            // 
            // lvIssueUnits
            // 
            this.lvIssueUnits.AccessibleDescription = "assigned units";
            this.lvIssueUnits.AccessibleName = "assigned units";
            this.lvIssueUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvIssueUnits.CheckBoxes = true;
            this.lvIssueUnits.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader1,
            this.columnHeader2,
            this.columnHeader3,
            this.columnHeader4,
            this.columnHeader5});
            this.lvIssueUnits.ContextMenu = this.mnuInspection;
            this.lvIssueUnits.FullRowSelect = true;
            this.lvIssueUnits.HideSelection = false;
            this.lvIssueUnits.Location = new System.Drawing.Point(4, 4);
            this.lvIssueUnits.MultiSelect = false;
            this.lvIssueUnits.Name = "lvIssueUnits";
            this.lvIssueUnits.Size = new System.Drawing.Size(410, 305);
            this.lvIssueUnits.SmallImageList = this.imageList1;
            this.lvIssueUnits.TabIndex = 4;
            this.lvIssueUnits.UseCompatibleStateImageBehavior = false;
            this.lvIssueUnits.View = System.Windows.Forms.View.Details;
            this.lvIssueUnits.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvUnits_ItemCheck);
            this.lvIssueUnits.SelectedIndexChanged += new System.EventHandler(this.lvUnits_SelectedIndexChanged);
            this.lvIssueUnits.Leave += new System.EventHandler(this.lvUnits_Leave);
            this.lvIssueUnits.MouseMove += new System.Windows.Forms.MouseEventHandler(this.lvIssueUnits_MouseMove);
            // 
            // columnHeader1
            // 
            this.columnHeader1.Text = "Issue?";
            this.columnHeader1.Width = 55;
            // 
            // columnHeader2
            // 
            this.columnHeader2.Text = "Unit ID";
            this.columnHeader2.Width = 100;
            // 
            // columnHeader3
            // 
            this.columnHeader3.Text = "Product";
            this.columnHeader3.Width = 80;
            // 
            // columnHeader4
            // 
            this.columnHeader4.Text = "ABO/Rh";
            this.columnHeader4.Width = 65;
            // 
            // columnHeader5
            // 
            this.columnHeader5.Text = "Expiration Date";
            this.columnHeader5.Width = 95;
            // 
            // mnuInspection
            // 
            this.mnuInspection.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.menuItem1,
            this.menuItem2});
            // 
            // menuItem1
            // 
            this.menuItem1.Index = 0;
            this.menuItem1.Text = "&Satisfactory";
            // 
            // menuItem2
            // 
            this.menuItem2.Index = 1;
            this.menuItem2.Text = "&Unsatisfactory";
            // 
            // imageList1
            // 
            this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
            this.imageList1.TransparentColor = System.Drawing.Color.Transparent;
            this.imageList1.Images.SetKeyName(0, "");
            this.imageList1.Images.SetKeyName(1, "");
            // 
            // pageEmergencyIssueUnits
            // 
            this.pageEmergencyIssueUnits.Controls.Add(this.lvEmergencyIssueUnits);
            this.pageEmergencyIssueUnits.Location = new System.Drawing.Point(4, 23);
            this.pageEmergencyIssueUnits.Name = "pageEmergencyIssueUnits";
            this.pageEmergencyIssueUnits.Size = new System.Drawing.Size(418, 314);
            this.pageEmergencyIssueUnits.TabIndex = 1;
            this.pageEmergencyIssueUnits.Text = "Emergency Issue Units";
            this.pageEmergencyIssueUnits.Visible = false;
            // 
            // lvEmergencyIssueUnits
            // 
            this.lvEmergencyIssueUnits.AccessibleDescription = "emergency issued units";
            this.lvEmergencyIssueUnits.AccessibleName = "emergency issued units";
            this.lvEmergencyIssueUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvEmergencyIssueUnits.CheckBoxes = true;
            this.lvEmergencyIssueUnits.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader10,
            this.columnHeader11,
            this.columnHeader12,
            this.columnHeader13,
            this.columnHeader14});
            this.lvEmergencyIssueUnits.ContextMenu = this.mnuInspection;
            this.lvEmergencyIssueUnits.FullRowSelect = true;
            this.lvEmergencyIssueUnits.HideSelection = false;
            this.lvEmergencyIssueUnits.Location = new System.Drawing.Point(4, 4);
            this.lvEmergencyIssueUnits.MultiSelect = false;
            this.lvEmergencyIssueUnits.Name = "lvEmergencyIssueUnits";
            this.lvEmergencyIssueUnits.Size = new System.Drawing.Size(410, 305);
            this.lvEmergencyIssueUnits.SmallImageList = this.imageList1;
            this.lvEmergencyIssueUnits.TabIndex = 4;
            this.lvEmergencyIssueUnits.UseCompatibleStateImageBehavior = false;
            this.lvEmergencyIssueUnits.View = System.Windows.Forms.View.Details;
            this.lvEmergencyIssueUnits.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvUnits_ItemCheck);
            this.lvEmergencyIssueUnits.SelectedIndexChanged += new System.EventHandler(this.lvUnits_SelectedIndexChanged);
            this.lvEmergencyIssueUnits.Leave += new System.EventHandler(this.lvUnits_Leave);
            this.lvEmergencyIssueUnits.MouseMove += new System.Windows.Forms.MouseEventHandler(this.lvEmergencyIssueUnits_MouseMove);
            // 
            // columnHeader10
            // 
            this.columnHeader10.Text = "Issue?";
            this.columnHeader10.Width = 55;
            // 
            // columnHeader11
            // 
            this.columnHeader11.Text = "Unit ID";
            this.columnHeader11.Width = 100;
            // 
            // columnHeader12
            // 
            this.columnHeader12.Text = "Product";
            this.columnHeader12.Width = 80;
            // 
            // columnHeader13
            // 
            this.columnHeader13.Text = "ABO/Rh";
            this.columnHeader13.Width = 65;
            // 
            // columnHeader14
            // 
            this.columnHeader14.Text = "Expiration Date";
            this.columnHeader14.Width = 95;
            // 
            // grpSelect
            // 
            this.grpSelect.AccessibleDescription = "Unit Select";
            this.grpSelect.AccessibleName = "Unit Select";
            this.grpSelect.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpSelect.Controls.Add(this.btnClear);
            this.grpSelect.Controls.Add(this.txtProductID);
            this.grpSelect.Controls.Add(this.txtUnitID);
            this.grpSelect.Controls.Add(this.pictureBox2);
            this.grpSelect.Controls.Add(this.pictureBox4);
            this.grpSelect.Controls.Add(this.lblUnitID);
            this.grpSelect.Controls.Add(this.lblProduct);
            this.grpSelect.Location = new System.Drawing.Point(48, 108);
            this.grpSelect.Name = "grpSelect";
            this.grpSelect.Size = new System.Drawing.Size(426, 72);
            this.grpSelect.TabIndex = 2;
            this.grpSelect.TabStop = false;
            this.grpSelect.Text = "Unit Select";
            // 
            // btnClear
            // 
            this.btnClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnClear.Location = new System.Drawing.Point(342, 42);
            this.btnClear.Name = "btnClear";
            this.btnClear.Size = new System.Drawing.Size(75, 23);
            this.btnClear.TabIndex = 4;
            this.btnClear.Text = "C&lear";
            this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
            // 
            // txtProductID
            // 
            this.txtProductID.AccessibleDescription = "product";
            this.txtProductID.AccessibleName = "product";
            this.txtProductID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtProductID.Barcode = false;
            this.txtProductID.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
            this.txtProductID.Location = new System.Drawing.Point(88, 44);
            this.txtProductID.MaxLength = 10;
            this.txtProductID.Name = "txtProductID";
            this.txtProductID.RecursionGuard = false;
            this.txtProductID.Size = new System.Drawing.Size(246, 20);
            this.txtProductID.TabIndex = 3;
            this.txtProductID.Leave += new System.EventHandler(this.txtProductID_Leave);
            // 
            // txtUnitID
            // 
            this.txtUnitID.AccessibleDescription = "unit i d";
            this.txtUnitID.AccessibleName = "unit i d";
            this.txtUnitID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtUnitID.Barcode = false;
            this.txtUnitID.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
            this.txtUnitID.Location = new System.Drawing.Point(88, 20);
            this.txtUnitID.MaxLength = 15;
            this.txtUnitID.Name = "txtUnitID";
            this.txtUnitID.Size = new System.Drawing.Size(246, 20);
            this.txtUnitID.TabIndex = 1;
            this.txtUnitID.Leave += new System.EventHandler(this.txtUnitID_Leave);
            // 
            // pictureBox2
            // 
            this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
            this.pictureBox2.Location = new System.Drawing.Point(8, 20);
            this.pictureBox2.Name = "pictureBox2";
            this.pictureBox2.Size = new System.Drawing.Size(20, 20);
            this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox2.TabIndex = 18;
            this.pictureBox2.TabStop = false;
            // 
            // pictureBox4
            // 
            this.pictureBox4.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox4.Image")));
            this.pictureBox4.Location = new System.Drawing.Point(8, 44);
            this.pictureBox4.Name = "pictureBox4";
            this.pictureBox4.Size = new System.Drawing.Size(20, 20);
            this.pictureBox4.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox4.TabIndex = 16;
            this.pictureBox4.TabStop = false;
            // 
            // lblUnitID
            // 
            this.lblUnitID.Location = new System.Drawing.Point(28, 20);
            this.lblUnitID.Name = "lblUnitID";
            this.lblUnitID.Size = new System.Drawing.Size(56, 20);
            this.lblUnitID.TabIndex = 0;
            this.lblUnitID.Text = "Unit ID*";
            this.lblUnitID.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblProduct
            // 
            this.lblProduct.Location = new System.Drawing.Point(28, 44);
            this.lblProduct.Name = "lblProduct";
            this.lblProduct.Size = new System.Drawing.Size(56, 20);
            this.lblProduct.TabIndex = 2;
            this.lblProduct.Text = "Product*";
            this.lblProduct.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // patientDisplayPanel1
            // 
            this.patientDisplayPanel1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.patientDisplayPanel1.EnabledBloodAvailButton = false;
            this.patientDisplayPanel1.EnabledMedicationButton = false;
            this.patientDisplayPanel1.EnabledRecentOrdersButton = false;
            this.patientDisplayPanel1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientDisplayPanel1.EnabledSIAndTRButton = false;
            this.patientDisplayPanel1.EnabledTransfusionReactionHistoryButton = false;
            this.patientDisplayPanel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.patientDisplayPanel1.Location = new System.Drawing.Point(4, 28);
            this.patientDisplayPanel1.Name = "patientDisplayPanel1";
            this.patientDisplayPanel1.Patient = null;
            this.patientDisplayPanel1.Size = new System.Drawing.Size(758, 40);
            this.patientDisplayPanel1.TabIndex = 10;
            // 
            // FrmIssueBloodComponents
            // 
            this.AcceptButton = this.btnIssueUnits;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancelUnits;
            this.ClientSize = new System.Drawing.Size(762, 563);
            this.Controls.Add(this.patientDisplayPanel1);
            this.Controls.Add(this.grpSelect);
            this.Controls.Add(this.tabUnits);
            this.Controls.Add(this.grpSelectedUnit);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.grpIssueDetails);
            this.Controls.Add(this.btnCancelUnits);
            this.Controls.Add(this.btnIssueUnits);
            this.hlphelpChm.SetHelpKeyword(this, "Issue_Blood_Components.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(750, 590);
            this.Name = "FrmIssueBloodComponents";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Issue Blood Components";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmIssueBloodComponents_KeyDownSpeakMessage);
            this.Controls.SetChildIndex(this.btnIssueUnits, 0);
            this.Controls.SetChildIndex(this.btnCancelUnits, 0);
            this.Controls.SetChildIndex(this.grpIssueDetails, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.grpSelectedUnit, 0);
            this.Controls.SetChildIndex(this.tabUnits, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.grpSelect, 0);
            this.Controls.SetChildIndex(this.patientDisplayPanel1, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpIssueDetails.ResumeLayout(false);
            this.grpIssueDetails.PerformLayout();
            this.grpImage.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.grpSelectedUnit.ResumeLayout(false);
            this.tabUnits.ResumeLayout(false);
            this.pageIssueUnits.ResumeLayout(false);
            this.pageEmergencyIssueUnits.ResumeLayout(false);
            this.grpSelect.ResumeLayout(false);
            this.grpSelect.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox4)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC073.FrmIssueBloodComponents());
			//
			this.bloodBagLabel1.Visible = true;
			this.bloodUnitDetailsTab1.Visible = true;
			this.vbecsLogo1.Title = "Issue Blood Components";
			//
			this.patientDisplayPanel1.Patient = _pUI.Patient;
			//
			this.txtIssueDate.Text		= Common.VBECSDateTime.FormatDateTimeString(_pUI.IssueDate);
			this.txtTransporter.Text	= _pUI.Transporter;
			this.txtLocationName.Text	= _pUI.IssueToLocation;

			PopulateListViews();

			// The BOL will inform the UI that warnings were generated related to a unit by 
			// raising this custom event.
			_pUI.IssueMessagesEvent += new BOL.PatientUnitIssue.IssueMessagesEventHandler(ShowValidationMessages);
		}


		/// <summary>
		/// Populates both the regular and emergency issue unit list views
		/// </summary>
		private void PopulateListViews()
		{
			lvIssueUnits.Items.Clear();
			lvEmergencyIssueUnits.Items.Clear();
			
			// regular issue
			foreach (BOL.BloodUnit bloodUnit in _pUI.Units)
			{
				string messages = _pUI.GetMessagesForTooltip(bloodUnit.BloodUnitGuid);

				ListViewItem lVI = new ListViewItem();
				lVI.Tag = bloodUnit;

				if (messages.Trim().Length > 0)
				{
					if (_pUI.UnitSelectable(bloodUnit.BloodUnitGuid))
					{	
						lVI.ImageIndex = 0;
					}
					else
					{
						lVI.ImageIndex = 1;
						lVI.ForeColor = System.Drawing.Color.FromKnownColor(KnownColor.GrayText);
					}
				}

				lVI.SubItems.Add(bloodUnit.EyeReadableUnitId);
				lVI.SubItems.Add(bloodUnit.ProductShortName+", "+bloodUnit.FullProductCode);
				lVI.SubItems.Add(bloodUnit.BloodUnitMedia.AboRh.AboRHText);
				lVI.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(bloodUnit.BloodUnitMedia.UnitExpirationDate));
				// for Visual Inspection indicator
				lVI.SubItems.Add(string.Empty);
				

				this.lvIssueUnits.Items.Add(lVI);
			}
			controls.VbecsFunction.SetColumnWidths(this.lvIssueUnits);


			// emergency issue
			foreach (BOL.BloodUnit bloodUnit in _pUI.EmergencyUnits)
			{
				string messages = _pUI.GetMessagesForTooltip(bloodUnit.BloodUnitGuid);

				ListViewItem lVI = new ListViewItem();
				lVI.Tag = bloodUnit;
				if (messages.Trim().Length > 0)
				{
					if (_pUI.UnitSelectable(bloodUnit.BloodUnitGuid))
					{	
						lVI.ImageIndex = 0;
					}
					else
					{
						lVI.ImageIndex = 1;
						lVI.ForeColor = System.Drawing.Color.FromKnownColor(KnownColor.GrayText);
					}
				}
				lVI.SubItems.Add(bloodUnit.EyeReadableUnitId);
				lVI.SubItems.Add(bloodUnit.ProductShortName+", "+bloodUnit.FullProductCode);
				lVI.SubItems.Add(bloodUnit.BloodUnitMedia.AboRh.AboRHText);
				lVI.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(bloodUnit.BloodUnitMedia.UnitExpirationDate));
				// for Visual Inspection indicator
				lVI.SubItems.Add(string.Empty);
				
				this.lvEmergencyIssueUnits.Items.Add(lVI);
			}
			controls.VbecsFunction.SetColumnWidths(this.lvEmergencyIssueUnits);
		}

		
		/// <summary>
		/// Displays all of the messages associated with the selection of a particular unit.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ShowValidationMessages(object sender, BOL.PatientUnitIssue.IssueMessagesEventArgs e)
		{
			ArrayList unitsForRemoval = new ArrayList();
			bool beep = false;
			bool promptForPrinting = false;
	
			Hashtable messages = e.Messages;
			IDictionaryEnumerator enumerator = messages.GetEnumerator();
			
			StringBuilder informationalMessages = new StringBuilder("The following messages are informational only:\n");
			StringBuilder exceptionReportMessages = new StringBuilder("The following warnings require an override:\n");
			// for message formatting
			bool informationalMessagesExist = false;
			bool exceptionMessagesExist = false;

			string finalMessage = string.Empty;
			

			while (enumerator.MoveNext())
			{
				Common.StrRes.StringResourceItem message = (Common.StrRes.StringResourceItem) enumerator.Key;
				Common.ExceptionType exception = (Common.ExceptionType) enumerator.Value;


				// Tag printing part of BR_73.31
				if (message.ResString == Common.StrRes.ConfMsg.UC073.EmergencyIssue().ResString)
				{
					promptForPrinting = true;
				}
				
				if (!beep) beep = BOL.PatientUnitIssue.Beep(message); 
				
				// If unit cannot be chosen, it will only have one error message and the Hashtable
				// value will be Unissuable.
				if ( ((Common.ExceptionType) enumerator.Value) == Common.ExceptionType.Unissuable )
				{
					if (beep) Common.Utility.MessageBeep();
					// Convert the MessageBox to a System Error so that a beep is heard. CRs 2115, 2193, 2195, 2199
					GUI.GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(message.ResString));
				}
				// CR3272: added if statement so message processing does not continue if unit is unissueable 
				else if ( _pUI.UnitSelectable(e.BloodUnit.BloodUnitGuid) )
				{
					// Group all exception report messages together and the same for messages
					if ( exception != Common.ExceptionType.Unissuable && 
						exception != Common.ExceptionType.Unknown)
					{
						exceptionReportMessages.Append("*" + message.ResString + "\n");
						exceptionMessagesExist = true;
					}
					else
					{
						informationalMessages.Append("*" + message.ResString + "\n");
						informationalMessagesExist = true;
					}
				}
			}

			if (exceptionMessagesExist)
			{
				if (informationalMessagesExist)
				{
					finalMessage = informationalMessages.ToString() + "\n" + exceptionReportMessages.ToString() + "\n" + "Proceed?";
				}
				else
				{
					finalMessage = exceptionReportMessages.ToString() + "\n" + "Proceed?";
				}
			}
			else 
			{
				if (informationalMessagesExist)
				{
					finalMessage = informationalMessages.ToString() + "\n" + "Proceed?";
				}
			}

			if (exceptionMessagesExist || informationalMessagesExist)
			{
				if (beep) Common.Utility.MessageBeep();
				DialogResult result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.Dynamic(finalMessage));
				if (result == DialogResult.Yes)
				{
					DlgOverrideComment dlg = new DlgOverrideComment("Comment required", "A comment is required to proceed with this override.  Cancelling will result in the unit not being selected!", "UI");

                    dlg.ShowDialogFromLockedParent(this, false);
                    if (dlg.DialogResult == DialogResult.OK)
					{
						string printing = "Do you need to print the tags and forms?";
						if (promptForPrinting)
						{
							if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.Dynamic(printing)) == DialogResult.Yes)
							{
								// Print tags
								BOL.CautionTag cautionTag = new BOL.CautionTag(e.BloodUnit, _pUI.Patient, ThisUser, true);
								cautionTag.Print(Common.Print.CautionTag);

								// Print BTRF
								System.Drawing.Printing.PrinterSettings settings = new System.Drawing.Printing.PrinterSettings();
								printDialog1.PrinterSettings = settings;
								if (printDialog1.ShowDialog(this) == DialogResult.OK)
								{
                                    ReportDataSource reportSourceMain = new ReportDataSource();
                                    reportSourceMain.Name = "BTRFDataSet";
                                    reportSourceMain.Value = cautionTag.GetBtrfDataSet().Tables[0];

                                    Assembly assembly = Assembly.LoadFrom("Reports.dll");
                                    Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodTransfusionRecordForm.BloodTransfusionRecordForm.rdlc");

                                    LocalReport report = new LocalReport();
                                    report.DataSources.Add(reportSourceMain);
                                    report.LoadReportDefinition(stream);
                                    report.DisplayName = "BTRF";

								    using (var reportPrinter = new BOL.VbecsReportPrinter(settings, false, report))
								    {
								        reportPrinter.Print();
								    }
								}
							}
						}
						
						enumerator.Reset();
						while (enumerator.MoveNext())
						{
							Common.StrRes.StringResourceItem message = (Common.StrRes.StringResourceItem) enumerator.Key;
							Common.ExceptionType exceptionType = (Common.ExceptionType) enumerator.Value;
						
							if (exceptionType != Common.ExceptionType.Unknown &&
								exceptionType != Common.ExceptionType.Unissuable)
							{
								BOL.ExceptionReport exRep = new BOL.ExceptionReport(exceptionType, dlg.Comment, Common.LogonUser.LogonUserName);
							
								exRep.GenerateExceptionUnitIssue(_pUI, e.BloodUnit);
								_pUI.IssueExceptions.Add(exRep);
							}
						}

						_pUI.AddIssuedUnitComment(dlg.Comment);
						_pUI.UnitOK = true;						
					}
				}
			}
		}


		private void ValidateUnitID()
		{
			this.errError.SetVbecsError(this.txtProductID, string.Empty); // **** 508 Compliance ***
			string errorMessage;
			try
			{
				if (txtUnitID.Text == String.Empty && txtProductID.Text == String.Empty) 
				{
				}
				else 
				{
					//
					if ((_isbtProductCode.IsMatch(txtProductID.Text) || _codabarProductCode.IsMatch(txtProductID.Text))
						&& (_isbtUnitID.IsMatch(txtUnitID.Text) || _codabarUnitID.IsMatch(txtUnitID.Text)))
					{
						if(txtProductID.Text.Length >= 5 && this.txtUnitID.Text.Length > 0)
						{
							try
							{
								System.Guid bloodUnitGUID = BOL.BloodUnit.GetBloodUnitGuid(txtUnitID.Text, txtProductID.Text.Substring(0,5), Common.LogonUser.LogonUserDivisionCode, BOL.BloodUnit.GetUnitDivisionId(this.txtProductID.Text));

								if ((_scannedBloodUnit == null) || (!System.Guid.Equals(_scannedBloodUnit.BloodUnitGuid,bloodUnitGUID)))
								{
									_scannedBloodUnit = new BOL.BloodUnit(bloodUnitGUID);
								}
                                
								using (new WaitCursor())
								{
									//CR 2128
									if(this.txtUnitID.Text != this._scannedBloodUnit.EyeReadableUnitId)
									{
										this.txtUnitID.Text = this._scannedBloodUnit.EyeReadableUnitId;
									}
									CheckUnit(_scannedBloodUnit);
								}
							}

							catch(Exception exp)
							{
								this.errError.SetVbecsError(this.txtProductID, exp.Message.ToString()); // **** 508 Compliance ***						
							}
						}
					}
				}
			}
			catch(Exception exp)
			{
				this.errError.SetVbecsError(this.txtProductID, exp.Message.ToString()); // **** 508 Compliance ***
				
				errorMessage = exp.Message.ToString();
			}
		}

		private void ValidateProductCode()
		{
			this.errError.SetVbecsError(this.txtProductID, string.Empty); // **** 508 Compliance ***
			try
			{
				if (txtUnitID.Text == String.Empty && txtProductID.Text == String.Empty) 
				{
				}
				else 
				{
					//
					if (_isbtProductCode.IsMatch(txtProductID.Text) || this._codabarProductCode.IsMatch(txtProductID.Text))
					{
						if(txtProductID.Text.Length >= 5 && this.txtUnitID.Text.Length > 0)
						{
							try
							{
								System.Guid bloodUnitGUID = BOL.BloodUnit.GetBloodUnitGuid(txtUnitID.Text, txtProductID.Text.Substring(0,5), Common.LogonUser.LogonUserDivisionCode, BOL.BloodUnit.GetUnitDivisionId(txtProductID.Text));

								if ((_scannedBloodUnit == null) || (!System.Guid.Equals(_scannedBloodUnit.BloodUnitGuid,bloodUnitGUID)))
								{
									_scannedBloodUnit = new BOL.BloodUnit(bloodUnitGUID);
								}

								if ((_isbtProductCode.IsMatch(txtProductID.Text) || this._codabarProductCode.IsMatch(txtProductID.Text))
									&& (_isbtUnitID.IsMatch(txtUnitID.Text) || this._codabarUnitID.IsMatch(txtUnitID.Text)))
								{
									using (new WaitCursor())
									{
										//CR 2128
										if(this.txtUnitID.Text != this._scannedBloodUnit.EyeReadableUnitId)
										{
											this.txtUnitID.Text = this._scannedBloodUnit.EyeReadableUnitId;
										}
										CheckUnit(_scannedBloodUnit);
									}
									
								}
							}

							catch(Exception exp)
							{
								this.errError.SetVbecsError(this.txtProductID, exp.Message.ToString()); // **** 508 Compliance ***
							}
						}
					}
				}
			}
			catch(Exception exp)
			{
				ExceptionManagement.ExceptionManager.Publish(exp);
				this.errError.SetVbecsError(this.txtProductID, exp.Message.ToString()); // **** 508 Compliance ***
			}
		}

		private void CheckUnit(BOL.BloodUnit bloodUnit)
		{
			bool locked = false;

			bool found = false;
			int counter = 0;

			// First, look for the item in the normal list.
			foreach(ListViewItem lVI in this.lvIssueUnits.Items)
			{
				if ( ((BOL.BloodUnit) lVI.Tag).BloodUnitGuid == bloodUnit.BloodUnitGuid)
				{
					if (!_pUI.UnitSelected( ((BOL.BloodUnit) lVI.Tag).BloodUnitGuid ))
					{
						System.Guid ouGuid = _pUI.GetOrderedUnitAssociatedWithUnit(bloodUnit.BloodUnitGuid).OrderedUnitGuid;;
						locked = this.SetLocks(ouGuid,bloodUnit.BloodUnitStatus.BloodUnitStatusGuid);
						
						if (locked)
						{
                            if (_pUI.AddUnit((BOL.BloodUnit)lVI.Tag, false))
                            {
                                // This is to bring the tab that the unit is on to the
                                // forefront.  This is done in case the unit was selected
                                // by scanning/ typing the unit id.
                                this.tabUnits.SelectedIndex = 0;

                                lVI.Checked = true;
                            } // CR3260: clear the unit selector
                            else
                            {
                                this.errError.SetVbecsError(this.txtProductID, string.Empty); // **** 508 Compliance ***

                                this.txtUnitID.Text = string.Empty;
                                this.txtProductID.Text = string.Empty;
                            }
						}
					}
					
					found = true;
					break;
				}
				counter++;
			}

			// if not found, look for the item in the other view
			if (!found)
			{
				foreach(ListViewItem lVI in this.lvEmergencyIssueUnits.Items)
				{
					if ( ((BOL.BloodUnit) lVI.Tag).BloodUnitGuid == bloodUnit.BloodUnitGuid)
					{
						if (!_pUI.UnitSelected( ((BOL.BloodUnit) lVI.Tag).BloodUnitGuid ))
						{
							System.Guid ouGuid = _pUI.GetOrderedUnitAssociatedWithUnit(bloodUnit.BloodUnitGuid).OrderedUnitGuid;;
							locked = this.SetLocks(ouGuid,bloodUnit.BloodUnitStatus.BloodUnitStatusGuid);
						
							if (locked)
							{
                                if (_pUI.AddUnit((BOL.BloodUnit)lVI.Tag, true))
                                {
                                    // This is to bring the tab that the unit is on to the
                                    // forefront.  This is done in case the unit was selected
                                    // by scanning/ typing the unit id.
                                    this.tabUnits.SelectedIndex = 1;

                                    lVI.Checked = true;
                                } // CR3260: clear the unit selector
                                else
                                {
                                    this.errError.SetVbecsError(this.txtProductID, string.Empty); // **** 508 Compliance ***

                                    this.txtUnitID.Text = string.Empty;
                                    this.txtProductID.Text = string.Empty;
                                }
							}
						}
						
						found = true;
						break;
					}
				}
			}

			// BR_73.13
			if (!found)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC073.NotIssueable());
			}
		}

		#endregion


		#region events

		private void lvUnits_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			ListView lv = (System.Windows.Forms.ListView) sender;
			if (lv.SelectedIndices.Count > 0)
			{
				ListViewItem lVI = lv.SelectedItems[0];
			
				BOL.BloodUnit bu = (BOL.BloodUnit) lVI.Tag;
				this.bloodBagLabel1.BloodUnit = bu;
				this.bloodUnitDetailsTab1.BloodUnit = bu;
				cbUnsatisfactory.Enabled = true;
			}
			else
			{
				this.bloodBagLabel1.BloodUnit = null;
				this.bloodUnitDetailsTab1.BloodUnit = null;
				cbUnsatisfactory.Enabled = false;
			}
			this.SpeakListViewWithCheckBox(lv);
		}

		private void lvUnits_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			ListView lv = (ListView) sender;
			ListViewItem lVI = lv.Items[e.Index];
			BOL.BloodUnit bloodUnit = (BOL.BloodUnit) lVI.Tag;

			System.Guid ouGuid = _pUI.GetOrderedUnitAssociatedWithUnit(bloodUnit.BloodUnitGuid).OrderedUnitGuid;;
			bool locked;

			if (_loading == false)
			{
				if ((lv.SelectedItems.Count==0) || (lVI != lv.SelectedItems[0]))
				{
					lVI.Selected = true;
				}
				//
				BOL.Specimen specimen =  _pUI.GetSpecimenAssociatedWithUnit(bloodUnit.BloodUnitGuid);

				if (e.NewValue == System.Windows.Forms.CheckState.Checked)
				{
					if (_pUI.UnitSelectable(bloodUnit.BloodUnitGuid))
					{
						if (!_pUI.UnitSelected(bloodUnit.BloodUnitGuid) )
						{		
							// CR2899: removed specimen (it will now be unlocked when the form is closed)
							locked = this.SetLocks(ouGuid,bloodUnit.BloodUnitStatus.BloodUnitStatusGuid);
							
							if (locked)
							{
								bool unitAdded = _pUI.AddUnit(bloodUnit, lv.Name == "lvEmergencyIssueUnits");
								if (!unitAdded) 
								{
									//BR failure or user input, don't check the unit, so release the locks
									// CR2899: removed specimen (it will now be unlocked when the form is closed)
									this.ReleaseLocks(ouGuid, bloodUnit.BloodUnitStatus.BloodUnitStatusGuid);
									
									e.NewValue = CheckState.Unchecked;
								}
							}
							else
							{
								e.NewValue = CheckState.Unchecked;
							}
						}
					}
					else
					{
						e.NewValue = CheckState.Unchecked;
					}
				}
				else
				{
					if (!SelectionOrderValid(bloodUnit))
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC073.SelectionOrderInvalid());
						e.NewValue = CheckState.Checked;
					}
					else
					{
						if (_pUI.RemoveUnit(bloodUnit, false))
						{
							// CR2899: deleted specimen (this will now be released when the form closes)
							this.ReleaseLocks(ouGuid,bloodUnit.BloodUnitStatus.BloodUnitStatusGuid);		
						}
					}
				}
			}
		}


		/// <summary>
		/// Returns a boolean indicating if the selection order is valid.
		/// </summary>
		/// <param name="deselectedBloodUnit"></param>
		/// <returns></returns>
		private bool SelectionOrderValid(BOL.BloodUnit deselectedBloodUnit)
		{
			// if allogeneic, the selection order is fine - no need to proceed.
			if (!BOL.BloodUnit.IsAutologous(deselectedBloodUnit.DonationType.DonationTypeCode) && 
				!BOL.BloodUnit.IsDirected(deselectedBloodUnit.DonationType.DonationTypeCode) &&
				deselectedBloodUnit.DirectedPatient.PatientGuid == Guid.Empty) return true;
	
			foreach (ListViewItem lVI in this.lvIssueUnits.Items)
			{
				if (lVI.Checked)
				{
					BOL.BloodUnit bloodUnit = (BOL.BloodUnit) lVI.Tag;
					if (bloodUnit.DirectedPatient.PatientGuid != deselectedBloodUnit.BloodUnitGuid)
					{
						// If the deselected unit is autologous, make sure that none of the other checked units
						// are anything less than autologous.
						if (BOL.BloodUnit.IsAutologous(deselectedBloodUnit.DonationType.DonationTypeCode))
						{
							if (!BOL.BloodUnit.IsAutologous(bloodUnit.DonationType.DonationTypeCode) &&
								!ExceptionRecorded(bloodUnit))
							{
								return false;
							}
						}
							// If the deselected unit is directed, make sure that none of the other checked units
							// are anything less than directed.
						else if (BOL.BloodUnit.IsDirected(deselectedBloodUnit.DonationType.DonationTypeCode))
						{
							// A directed unit was deselected, but there are 
							if (!BOL.BloodUnit.IsAutologous(bloodUnit.DonationType.DonationTypeCode) && 
								!BOL.BloodUnit.IsDirected(bloodUnit.DonationType.DonationTypeCode) &&
								!ExceptionRecorded(bloodUnit))
							{
								return false;
							}
						} 
							// If the deselected unit is restricted, make sure that none of the other checked units
							// are anything less than restricted.
						else if (bloodUnit.DirectedPatient.PatientGuid != Guid.Empty)
						{
							// A directed unit was deselected, but there are 
							if (!BOL.BloodUnit.IsAutologous(bloodUnit.DonationType.DonationTypeCode) && 
								!BOL.BloodUnit.IsDirected(bloodUnit.DonationType.DonationTypeCode) &&
								bloodUnit.DirectedPatient.PatientGuid == Guid.Empty &&
								!ExceptionRecorded(bloodUnit))
							{
								return false;
							}
						} 
					}
				} // if checked
			} // foreach

			// repeat with the other ListView
			// Must check to see that the selection order is still valid
			foreach (ListViewItem lVI in this.lvEmergencyIssueUnits.Items)
			{
				if (lVI.Checked)
				{
					BOL.BloodUnit bloodUnit = (BOL.BloodUnit) lVI.Tag;
					if (bloodUnit.DirectedPatient.PatientGuid != deselectedBloodUnit.BloodUnitGuid)
					{
						// If the deselected unit is autologous, make sure that none of the other checked units
						// are anything less than autologous.
						if (BOL.BloodUnit.IsAutologous(deselectedBloodUnit.DonationType.DonationTypeCode))
						{
							if (!BOL.BloodUnit.IsAutologous(bloodUnit.DonationType.DonationTypeCode) &&
								!ExceptionRecorded(bloodUnit))
							{
								return false;
							}
						}
							// If the deselected unit is directed, make sure that none of the other checked units
							// are anything less than directed.
						else if (BOL.BloodUnit.IsDirected(deselectedBloodUnit.DonationType.DonationTypeCode))
						{
							// A directed unit was deselected, but there are 
							if (!BOL.BloodUnit.IsAutologous(bloodUnit.DonationType.DonationTypeCode) && 
								!BOL.BloodUnit.IsDirected(bloodUnit.DonationType.DonationTypeCode) &&
								!ExceptionRecorded(bloodUnit))
							{
								return false;
							}
						} 
							// If the deselected unit is restricted, make sure that none of the other checked units
							// are anything less than restricted.
						else if (bloodUnit.DirectedPatient.PatientGuid != Guid.Empty)
						{
							// A directed unit was deselected, but there are 
							if (!BOL.BloodUnit.IsAutologous(bloodUnit.DonationType.DonationTypeCode) && 
								!BOL.BloodUnit.IsDirected(bloodUnit.DonationType.DonationTypeCode) &&
								bloodUnit.DirectedPatient.PatientGuid == Guid.Empty &&
								!ExceptionRecorded(bloodUnit))
							{
								return false;
							}
						} 
					}
				} // if checked
			} // foreach
			return true;
		}

		private bool ExceptionRecorded(BOL.BloodUnit bloodUnit)
		{
			foreach (BOL.ExceptionReport excRep in _pUI.IssueExceptions)
			{
				if (excRep.ExceptionType == Common.ExceptionType.Less_restrictive_unit_issued &&
					(Guid) excRep.ExceptionData[Common.VbecsTables.ExceptionUnitIssue.UnitGuid] == bloodUnit.BloodUnitGuid )
				{
					return true;
				}
			}
			return false;			
		}

		private void rdoSatisfactory_Click(object sender, System.EventArgs e)
		{
			ListViewItem lVI = null;

			if (this.lvIssueUnits.SelectedIndices.Count > 0) lVI = lvIssueUnits.SelectedItems[0];
			else lVI = this.lvEmergencyIssueUnits.SelectedItems[0];

			lVI.SubItems[5].Text = "Yes";
		}


		private void rdoUnsatisfactory_Click(object sender, System.EventArgs e)
		{
			ListViewItem lVI = null;

			if (this.lvIssueUnits.SelectedIndices.Count > 0) lVI = lvIssueUnits.SelectedItems[0];
			else lVI = this.lvEmergencyIssueUnits.SelectedItems[0];

			lVI.SubItems[5].Text = "No";
		}


		// Allows for tooltips on a ListViewItem
		private void lvIssueUnits_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			ListViewItem lVI = this.lvIssueUnits.GetItemAt(e.X,e.Y);
			if ( lVI != null )
			{
				BOL.BloodUnit bloodUnit = (BOL.BloodUnit) lVI.Tag;
				string messages = _pUI.GetMessagesForTooltip(bloodUnit.BloodUnitGuid);

                //CR 3282 Setting tooltip on listview item instead of a listview
			    lvIssueUnits.ShowItemToolTips = true;
				lVI.ToolTipText = messages;
			} 
		}


		// Allows for tooltips on a ListViewItem
		private void lvEmergencyIssueUnits_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			ListViewItem lVI = this.lvEmergencyIssueUnits.GetItemAt(e.X,e.Y);
			if ( lVI != null )
			{
				BOL.BloodUnit bloodUnit = (BOL.BloodUnit) lVI.Tag;
				string messages = _pUI.GetMessagesForTooltip(bloodUnit.BloodUnitGuid);

                //CR 3282 Setting tooltip on listview item instead of a listview
                lvEmergencyIssueUnits.ShowItemToolTips = true;
                lVI.ToolTipText =  messages;
			} 
		}	

		private void btnIssueUnits_Click(object sender, System.EventArgs e)
		{
            // CR 3550
            if (_pUI.DidABORhChange())
            {
                GuiMessenger.ShowMessageBox(new Common.StrRes.StringResourceItem("Patient's ABO/Rh was modified by another user and units cannot be issued at this time. Please review the patients information before attempting to issue the unit again.", Common.StringResourceType.Information));
                this.Close();
                return;
            }
                               
            if (_pUI.DidAntigenNegativeRequirementsChange())
            {
                GuiMessenger.ShowMessageBox(new Common.StrRes.StringResourceItem("Patient's Antigen Negative requirements were modified by another user and units cannot be issued at this time. Please review the patients information before attempting to issue the unit again.", Common.StringResourceType.Information));
                this.Close();
                return;
            }

            if (_pUI.DidTransfusionRequirementsChange())
            {
                GuiMessenger.ShowMessageBox(new Common.StrRes.StringResourceItem("Patient's Transfusion requirements were modified by another user and units cannot be issued. Please refer to patient's reports for more information.", Common.StringResourceType.Information));
                this.Close();
                return;
            }
            // CR 3550

            
			DialogResult saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC073.UnitsSatisfactory());
			if (saveResult == DialogResult.Yes)
			{
			
				if(!_pUI.Save(_workloadProcessId))
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.GeneralError("save.  No units were issued."));
				}
				else
				{
					//CR 1441
					System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) _workloadProcessId);
					if(dt!= null && _workloadProcessId != Common.WorkloadProcessID.Unknown)
					{
						if(dt.Rows.Count == 0)
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
						}
					}
				}
			}
			// FooUnlock all locks associated with this UC now!  -- happens on baseForm_Closing
            this.Close();
		}

		private void CheckValid(object sender, System.EventArgs e)
		{
			btnIssueUnits.EnabledButton = _pUI.IsValid;
			btnIssueUnits.SetToolTip(_pUI.GetBrokenRulesMessage(this.Name));
		}

		private void cbUnsatisfactory_CheckedChanged(object sender, System.EventArgs e)
		{
			if (lvIssueUnits.SelectedIndices.Count > 0 || lvEmergencyIssueUnits.SelectedIndices.Count > 0)
			{
				if (cbUnsatisfactory.Checked)
				{
					Guid ouGuid = _pUI.GetOrderedUnitAssociatedWithUnit(this.bloodUnitDetailsTab1.BloodUnit.BloodUnitGuid).OrderedUnitGuid;
					
					//They can unsatisfactory check a unit - that's highlighted (not checked)
					if (this.SetLocks(ouGuid, this.bloodBagLabel1.BloodUnit.BloodUnitStatus.BloodUnitStatusGuid))
					{
						DialogResult result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC073.UnitUnsatisfactory());
						if (result == DialogResult.Yes)
						{
							_pUI.RemoveUnit(this.bloodUnitDetailsTab1.BloodUnit, true);

							// Release locks - because the unit has been removed from the listview
							this.ReleaseLocks(ouGuid, this.bloodBagLabel1.BloodUnit.BloodUnitStatus.BloodUnitStatusGuid);
																
							if (lvIssueUnits.SelectedItems.Count>0)
							{
								lvIssueUnits.Items.Remove(lvIssueUnits.SelectedItems[0]);
							}
							if (lvEmergencyIssueUnits.SelectedItems.Count>0)
							{
								lvEmergencyIssueUnits.Items.Remove(lvEmergencyIssueUnits.SelectedItems[0]);
							}
							this.lvIssueUnits.Refresh();

							cbUnsatisfactory.Checked = false;
							cbUnsatisfactory.Enabled = false;
							this.bloodBagLabel1.BloodUnit = null;
							this.bloodUnitDetailsTab1.BloodUnit = null;
						}
						else
						{
							cbUnsatisfactory.Checked = false;

							bool releaseLock = false;
							//We don't want to release the locks if they have the unit checked
							if (lvIssueUnits.SelectedItems.Count>0)
							{
								releaseLock = (!lvIssueUnits.SelectedItems[0].Checked);								
							}
							if (lvEmergencyIssueUnits.SelectedItems.Count>0)
							{
								releaseLock = (!lvEmergencyIssueUnits.SelectedItems[0].Checked);	
							}
							// Release locks
							this.ReleaseLocks(ouGuid, this.bloodBagLabel1.BloodUnit.BloodUnitStatus.BloodUnitStatusGuid);
						}
					}
					else
					{
						cbUnsatisfactory.Checked = false;
					}
				}
			}
		}


		private void lvUnits_Leave(object sender, System.EventArgs e)
		{
			if (!this.RecursionGuard)
			{
				this.RecursionGuard = true;

				try
				{
					if (!this.cbUnsatisfactory.Focus())
					{
						cbUnsatisfactory.Enabled = false;
					}
				}
				finally
				{
					this.RecursionGuard = false;
				}
			}
		}

		private void btnClear_Click(object sender, System.EventArgs e)
		{
			this.errError.SetVbecsError(this.txtProductID, string.Empty); // **** 508 Compliance ***

			this.txtUnitID.Text = string.Empty;
			this.txtProductID.Text = string.Empty;
		}

		#region select by scan
		// 1) Make sure a valid Unit ID/ Product Code has been entered.
		// 2) If valid, select it or display appropriate error message.

		private void txtProductID_Leave(object sender, System.EventArgs e)
		{
			ValidateUnitID();
		}

		private void txtUnitID_Leave(object sender, System.EventArgs e)
		{
			ValidateProductCode();
		}

		private void btnCancelUnits_Click(object sender, System.EventArgs e)
		{
			// GUnlock all blood unit status 
			// GUnlock all ordered units
			// GUnlock all specimens
			this.Close();
		}

		#endregion

		private void tabUnits_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (tabUnits.SelectedTab == this.pageEmergencyIssueUnits)
			{
				this.hlphelpChm.SetHelpKeyword(this, "Issue_Blood_Components.htm");
			}
			else
			{
				this.hlphelpChm.SetHelpKeyword(this, "Issue_Blood_Components.htm");
			}

		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmIssueBloodComponents_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			
			textToSpeak = this.bloodUnitDetailsTab1.GetErrorMessages();

			if (this.btnIssueUnits.EnabledButton == false)
			{
                //CR 3282 getting tooltips from listview items
                for (int i = 0; i < lvIssueUnits.Items.Count; i++)
                {
                    textToSpeak = string.Concat(textToSpeak, "\n", this.lvIssueUnits.Items[i].ToolTipText);
                }

                //CR 3282 getting tooltips from listview items
                for (int i = 0; i < lvEmergencyIssueUnits.Items.Count; i++)
                {
                    textToSpeak = string.Concat(textToSpeak, "\n", this.lvEmergencyIssueUnits.Items[i].ToolTipText);
                }
			    textToSpeak = string.Concat(textToSpeak, "\n", this.btnIssueUnits.GetToolTip());
			
			}
			if(this.patientDisplayPanel1.Visible)
			{
				textToSpeak = string.Concat(textToSpeak, this.patientDisplayPanel1.GetErrorMessagesFor508());
			}


			this.SpeakMessage( textToSpeak );		
		}
		#endregion
	}
}

